/**
 * 
 */
package gov.va.med.mhv.common.api.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author DNS
 * 
 * The purpose of this class is to create an object mapper that won't 
 * error out in the event that a new property is introduced in an 
 * object being deserialized.
 *
 */
public class MhvIgnoreUnknownPropertiesObjectMapper extends ObjectMapper {
	
	private static final long serialVersionUID = -5809594231306337499L;

	public MhvIgnoreUnknownPropertiesObjectMapper() {
		disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
	}

}
